/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals;

import emulator.hardware.bits.BitCollector;
import emulator.hardware.bits.BitCollectorAndStrategy;
import emulator.hardware.bits.BitGate;
import emulator.hardware.bits.SharedBit;
import emulator.hardware.io.Port6522;
import emulator.hardware.io.Via6522;

public class KeyboardMatrix {
    private BitGate[] gates = null;
    private SharedBit restore_in;

    public void attachToVia(Via6522 via_keyboard, Via6522 via_restore) {
        this.attachToPort(via_keyboard.getPortB(), via_keyboard.getPortA());
        this.attachRestore(via_restore.getPortA());
    }

    private void attachRestore(Port6522 port) {
        this.restore_in = port.getControlBit(0);
    }

    public void attachToPort(Port6522 out_port, Port6522 in_port) {
        BitCollector[] port_inputs = new BitCollector[8];
        int i = 0;
        while (i < 8) {
            port_inputs[i] = new BitCollector(8, in_port.getInPortBit(i), new BitCollectorAndStrategy());
            ++i;
        }
        this.gates = new BitGate[8];
        i = 0;
        while (i < 8) {
            this.gates[i] = new BitGate(8, true);
            int j = 0;
            while (j < 8) {
                this.gates[i].setOutputBit(j, port_inputs[j].getBitAt(i));
                this.gates[i].getControlBit(j).setValue(false);
                ++j;
            }
            out_port.setOutPortBit(i, this.gates[i]);
            ++i;
        }
    }

    public void keyDown(int a, int b) {
        if (a < 0) {
            this.restore_in.setValue(false);
        } else {
            this.gates[b].getControlBit(a).setValue(true);
        }
    }

    public void keyUp(int a, int b) {
        if (a < 0) {
            this.restore_in.setValue(true);
        } else {
            this.gates[b].getControlBit(a).setValue(false);
        }
    }
}

